<?php
error_reporting(0);
set_time_limit(0);

include 'db.php'; // اتصال به دیتابیس

$auth = $_POST['auth'];
if (empty($auth)) {
    $response = ['status' => 'error', 'message' => 'invalid auth'];
    echo json_encode($response, JSON_UNESCAPED_UNICODE);
    exit();
}

$bio = $_POST['bio'];
if (empty($bio)) {
    $response = ['status' => 'error', 'message' => 'empty bio'];
    echo json_encode($response, JSON_UNESCAPED_UNICODE);
    exit();
}

if (strlen($bio) < 1 || strlen($bio) > 150) {
    $response = ['status' => 'error', 'message' => 'invalid bio length'];
    echo json_encode($response, JSON_UNESCAPED_UNICODE);
    exit();
}

// یافتن کاربر بر اساس auth
$stmt = $pdo->prepare("
    SELECT u.*, d.auth, d.platform, d.device, d.date, d.ip
    FROM users u
    JOIN devices d ON u.id = d.user_id
    WHERE d.auth = :auth
");
$stmt->execute(['auth' => $auth]);
$userDevice = $stmt->fetch(PDO::FETCH_ASSOC);

if (!$userDevice) {
    $response = ['status' => 'error', 'message' => 'invalid auth'];
    echo json_encode($response, JSON_UNESCAPED_UNICODE);
    exit();
}

if ($userDevice['ban']==='1') {
    $response = ['status' => 'error', 'message' => 'baned account'];
    echo json_encode($response, JSON_UNESCAPED_UNICODE);
    exit();
}

// بروزرسانی bio کاربر
$stmtUpdate = $pdo->prepare("UPDATE users SET bio = :bio, last_seen = :last_seen WHERE id = :user_id");
$stmtUpdate->execute([
    'bio' => $bio,
    'last_seen' => time(),
    'user_id' => $userDevice['id']
]);

$response = ['status' => 'success', 'message' => 'bio updated'];
echo json_encode($response, JSON_UNESCAPED_UNICODE);
?>